unit MemDump2;

interface

uses SysUtils, Dialogs, StdCtrls;

// =======================================================================
//     RqSize ,  
//   RqAddr,     .
// ShowOffSet     .  True 
//       RqAddr
//  Font  RqReport - Courier New, Size = 10
procedure MemToHexAndCharDump
             (RqAddr     : pointer;   //   
              RqSize     : integer;   //   
              RqReport   : TMemo;     //   
              ShowOffSet : boolean);  //   
// -----------------------------------------------------------------------
//       
//   RqSize ,    
// RqAddr.
function MemToHexStr (RqAddr : pointer; RqSize : integer): string;

// =======================================================================
//         
function HexCharStrToByte (RqStr : string; var Value : byte): boolean;
// -----------------------------------------------------------------------
//        
function HexCharStrToBin (RqStr   : string;    //  16- 
                          RqAddr  : pointer;   //   
                          RqSize  : integer    //   
                          ): boolean;

// =======================================================================
// =======================================================================

implementation

// =======================================================================
// =======================================================================
// -----------------------------------------------------------------------
//     
function ByteToHexStr (RqByte : byte): string;
const HexCharsArray : array[0..15] of char =
   ('0','1','2','3','4','5','6','7',
    '8','9','A','B','C','D','E','F');
begin
 //      Hex - 
 Result:= HexCharsArray[$0F and RqByte];
 //       
 Result:= HexCharsArray[($F0 and RqByte) shr 4] + Result;
end;
// -----------------------------------------------------------------------
//       
//   RqSize ,    
// RqAddr.
function MemToHexStr (RqAddr : pointer; RqSize : integer): string;
var pt1 : ^byte;    //   
    Ind : integer;  //    
begin
  Result := '';
  if (RqAddr <> nil) and (RqSize > 0)
  then begin
    pt1 := RqAddr;
    try
      for Ind := 0 to RqSize -1 do
      begin
        Result := Result + ByteToHexStr(pt1^);
        //   
        pt1 := Ptr(Integer(pt1) + 1);
      end;
    except
       ShowMessage(' .  .');
    end;
  end;
end;
// -----------------------------------------------------------------------
//     RqSize ,  
//   RqAddr,     .
procedure MemToHexAndCharDump
             (RqAddr     : pointer;   //   
              RqSize     : integer;   //   
              RqReport   : TMemo;     //   
              ShowOffSet : boolean);  //   

const SLen    = 16;               //      
      BlChar  = '.';              //  
var   pt1     : ^byte;            //      
      OCount  : integer;          //     
      BCount  : integer;          //     
      SCount  : integer;          //      
      WCount  : integer;          //      
      HStr    : string[80];       //   
      CStr    : string[80];       //   
      wp      : pointer;
begin

  if (RqAddr <> nil) and (RqSize > 0)
  then begin
    pt1     := RqAddr;
    BCount  := RqSize;
    OCount  := 0;
    if ShowOffSet
    then RqReport.Lines.Add('    ')
    else RqReport.Lines.Add('       ');
    try
      repeat //    
          wp  := pointer(OCount);
          if ShowOffSet
          then HStr   := Format('%p',[wp])  + ':' + '  '
          else HStr   := Format('%p',[pt1]) + ':' + '  ';   //#09;
          CStr   := '';
          SCount := SLen;
          WCount := SizeOf(integer);
          repeat  //    
            // HEX -  
            if BCount > 0
            then HStr := HStr + ByteToHexStr(pt1^)
            else HStr := HStr + BlChar + BlChar;
            WCount := WCount - 1;
            if WCount <= 0
            then begin
               HStr := HStr + ' ';
               WCount := SizeOf(integer);
            end;
            // CHAR -  
            if BCount > 0
            then begin
               if pt1^ < $20           //   
               then CStr := CStr + BlChar
               else CStr := CStr + Char(pt1^);
            end
            else CStr := CStr + BlChar;
            //   
            pt1 := Ptr(Integer(pt1) + 1);
            BCount := BCount - 1;
            SCount := SCount - 1;
            OCount := OCount + 1;
          until (SCount <=0);
          RqReport.Lines.Add(HStr + '  ' + CStr);
      until (BCount <= 0);
    except
       ShowMessage(' .  .');
    end;
  end;
end;
// =======================================================================
// -----------------------------------------------------------------------
//      
function CharToHalfByte(RqChar : char; var Value : byte) : boolean;
var wB : byte;
begin
   Result := True;
   wB := 0;
   case UpCase(RqChar) of
   '0' : wB := $0;
   '1' : wB := $1;
   '2' : wB := $2;
   '3' : wB := $3;
   '4' : wB := $4;
   '5' : wB := $5;
   '6' : wB := $6;
   '7' : wB := $7;
   '8' : wB := $8;
   '9' : wB := $9;
   'A' : wB := $A;
   'B' : wB := $B;
   'C' : wB := $C;
   'D' : wB := $D;
   'E' : wB := $E;
   'F' : wB := $F;
   else Result := False;
   end;
   if Result then Value := wB;
end;
// -----------------------------------------------------------------------
//         
function HexCharStrToByte (RqStr : string; var Value : byte): boolean;
var wB1, wB2 : byte;
begin
   Result := False;
   //   
   if Length(RqStr) <> 2 then Exit;
   wB1 := 0;
   Result := CharToHalfByte(RqStr[1], wB1);
   if not Result then Exit;
   //   
   wB2 := 0;
   Result := CharToHalfByte(RqStr[2], wB2);
   if not Result then Exit;
   //  
   Value := (wB1 shl 4) or wB2;
end;
// -----------------------------------------------------------------------
//        
function HexCharStrToBin (RqStr   : string;    //  16- 
                          RqAddr  : pointer;   //   
                          RqSize  : integer    //   
                          ): boolean;
var wP   : ^byte;
    wB   : byte;
    wCnt : integer;
    wStr : string;
    Ind  : integer;
begin
    Result := False;
    if (Length(RqStr) div 2) < RqSize
    then begin
       MessageDlg('   .'
                 + #13#10
                 + '    : ' + IntToStr(2 * RqSize)
                 + #13#10
                 + '  .',
                 mtWarning, [mbOk], 0);
       Exit;
    end;
    wP   := RqAddr;
    wCnt := 0;
    //      
    Ind := 1;
    try
      repeat
        wB := 0;
        //   
        wStr := Copy(RqStr, Ind, 2);
        Result := HexCharStrToByte(wStr, wB);
        if not Result
        then begin
           MessageDlg('   '
                     + #13#10
                     + '    : ' + IntToStr(Ind)
                     + #13#10
                     + '  .',
                     mtWarning, [mbOk], 0);
           Exit;
        end;
        wP^ := wB;
        wCnt := wCnt + 1;
        //      
        Ind := Ind + 2;
        //   
        wP := pointer(integer(wP) + 1);
      until (wCnt >= RqSize);
      Result := True;
    except
        Result := False;
        MessageDlg('   '
                  + #13#10
                  + '   : ' + format('%p', [wp])
                  + #13#10
                  + '  .',
                  mtError, [mbOk], 0);
    end;
end;

(*
//    
procedure TForm1.BttTestClick(Sender: TObject);
var Wstr : string;
    wP   : pointer;
    wI   : integer;
begin
   wI := 0;
   Wstr := EditTest.Text;
   wP := Addr(wI);
   if HexCharStrToBin (Wstr, wP,  4)
   then begin
      wP := Addr(wI);
      StTxtTest.Caption := MemToHexStr (wP, 4);
   end
   else StTxtTest.Caption := '';
end;
*)

// =======================================================================
end.
 